@extends('admin.layout.template')
@section('title', 'Quotation Details')

@section('content')

<div class="page-content">
    <div class="container-xxl">

        <div class="card mb-4">
            <div class="card-header">
                <h4>Edit Quotation</h4>
            </div>

            <div class="card-body">

                {{-- HEADER EDIT FORM --}}
                <form id="quotationUpdateForm">
                    @csrf
                    <input type="hidden" name="quotation_id" id="project_quotation_id" value="{{ $quotation->id }}">


                    <div class="row">

                        {{-- PROJECT NAME --}}
                        <div class="col-md-4">
                            <label>Project Name</label>
                            <input type="text" name="project_name" class="form-control"
                                value="{{ old('project_name', $quotation->project_name ?? '') }}">
                        </div>

                        {{-- CUSTOMER NAME --}}
                        <div class="col-md-4">
                            <label>Customer Name</label>
                            <input type="text" name="customer_name" class="form-control"
                                value="{{ old('customer_name', $quotation->customer_name ?? '') }}">
                        </div>

                        {{-- CUSTOMER PHONE --}}
                        <div class="col-md-4">
                            <label>Customer Phone</label>
                            <input type="text" name="customer_phone" class="form-control"
                                value="{{ old('customer_phone', $quotation->customer_phone ?? '') }}">
                        </div>

                        {{-- ADDRESS --}}
                        <div class="col-md-4 mt-3">
                            <label>Address</label>
                            <input type="text" name="address" class="form-control" value="{{ old('address', $quotation->address ?? '') }}">
                        </div>

                        {{-- PROJECT TYPE --}}
                        <div class="col-md-4 mt-3">
                            <label>Project Type</label>
                            <select name="project_type" class="form-select">
                                @foreach(['home','villa','flat','commercial'] as $type)
                                <option value="{{ $type }}"
                                    {{ ($quotation->project_type ?? '') == $type ? 'selected' : '' }}>
                                    {{ ucfirst($type) }}
                                </option>
                                @endforeach
                            </select>
                        </div>

                        {{-- EXPECTED COMPLETION --}}
                        <div class="col-md-4 mt-3">
                            <label>Expected Completion</label>
                            <input type="date" name="expected_completion_date"
                                class="form-control"
                                value="{{ old('expected_completion_date', $quotation->expected_completion_date ?? '') }}">
                        </div>


                        {{-- EMPLOYEE NAME --}}
                        <div class="col-md-4 mt-3">
                            <label>Employee Name</label>
                            <input type="text" name="employee_name" class="form-control"
                                value="{{ old('employee_name', $quotation->employee_name ?? '') }}">
                        </div>

                        {{-- EMPLOYEE CONTACT --}}
                        <div class="col-md-4 mt-3">
                            <label>Employee Contact</label>
                            <input type="text" name="employee_contact" class="form-control"
                                value="{{ old('employee_contact', $quotation->employee_contact ?? '') }}">
                        </div>

                        {{-- QUOTATION STATUS --}}
                        <div class="col-md-4 mt-3">
                            <label>Status</label>
                            <select name="status" class="form-select">
                                @foreach(['quoted','draft','final'] as $status)
                                <option value="{{ $status }}"
                                    {{ $quotation->status == $status ? 'selected' : '' }}>
                                    {{ ucfirst($status) }}
                                </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-md-12 mt-4">
                            <button type="button" id="updateQuotationBtn" class="btn btn-primary">
                                Update Quotation
                            </button>
                        </div>

                    </div>
                </form>

            </div>
        </div>

        <!-- //room selection  -->

        <div class="card">
            <div class="card-header d-flex justify-content-between">
                <h5>Rooms</h5>
               <button class="btn btn-success btn-sm"
        data-bs-toggle="modal"
        data-bs-target="#addRoomModal">
    + Add Room
</button>
            </div>

            <div class="card-body">

                @foreach($quotation->areas as $area)

                <div class="border p-3 mb-4">

                    <div class="d-flex justify-content-between mb-3">
                        <h6>{{ $area->area_name }}</h6>

                        <div>
                            <button class="btn btn-sm btn-primary editRoomBtn"
                                data-id="{{ $area->id }}"
                                data-name="{{ $area->area_name }}">
                                Edit
                            </button>

                            <button class="btn btn-sm btn-danger deleteRoomBtn"
                                data-id="{{ $area->id }}">
                                Delete
                            </button>

                            <button class="btn btn-sm btn-success addItemBtn"
                                data-area="{{ $area->id }}">
                                + Add Item
                            </button>
                        </div>
                    </div>

                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>Category</th>
                                <th>Product</th>
                                <th>Variant</th>
                                <th>Qty</th>
                                <th>Total</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>

                            @foreach($groupedItems[$area->id] ?? [] as $item)
                            <tr>
                                <td>{{ ucfirst($item->category) }}</td>
                                <td>{{ $item->product->name ?? '' }}</td>
                                <td>{{ $item->variant->sku ?? '' }}</td>
                                <td>{{ $item->quantity }}</td>
                                <td>₹ {{ number_format($item->total,2) }}</td>
                                <td>
                                    <button class="btn btn-sm btn-info editItemBtn"
                                        data-id="{{ $item->id }}">
                                        Edit
                                    </button>

                                    <button class="btn btn-sm btn-danger deleteItemBtn"
                                        data-id="{{ $item->id }}">
                                        Delete
                                    </button>

                                </td>
                            </tr>

                            @endforeach

                        </tbody>
                    </table>


                </div>
                @endforeach

                <div class="modal fade" id="itemModal" tabindex="-1">
                    <div class="modal-dialog modal-xl">
                        <div class="modal-content shadow-lg border-0">

                            <form id="itemForm">
                                @csrf

                                <input type="hidden" name="quotation_id" value="{{ $quotation->id }}">
                                <input type="hidden" name="area_id" id="quotation_area_id">
                                <input type="hidden" name="quotation_item_id" id="quotation_item_id">

                                <!-- HEADER -->
                                <div class="modal-header bg-light border-bottom">
                                    <h5 class="modal-title fw-semibold">Add / Edit Item</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                </div>

                                <!-- BODY -->
                                <div class="modal-body px-4 py-3">

                                    <!-- BASIC DETAILS -->
                                    <div class="row g-3 mb-3">

                                        <div class="col-md-3">
                                            <label class="form-label">Category</label>
                                            <select name="category" id="edit_category" class="form-select">
                                                <option value="">Select</option>
                                                @foreach(App\Models\Category::all() as $cat)
                                                <option value="{{ $cat->id }}" data-value="{{ strtolower($cat->name) }}">{{ ucfirst($cat->name) }}</option>
                                                @endforeach
                                            </select>
                                        </div>

                                        <div class="col-md-3">
                                            <label class="form-label">Subcategory</label>
                                            <select name="subcategory_id" id="edit_subcategory" class="form-select">
                                                <option>Select</option>
                                            </select>
                                        </div>

                                        <div class="col-md-3">
                                            <label class="form-label">Catalogue</label>
                                            <select name="product_id" id="edit_catalogue" class="form-select">
                                                <option>Select</option>
                                            </select>
                                        </div>

                                        <div class="col-md-3">
                                            <label class="form-label">SKU</label>
                                            <select name="variant_id" id="edit_sku" class="form-select">
                                                <option>Select</option>
                                            </select>
                                        </div>

                                    </div>



                                    <!-- ================= CURTAIN ================= -->
                                    <div id="curtain_section" class="category_section d-none mb-3">
                                        <h6 class="mb-3 text-muted">Curtain Details</h6>

                                        <div class="row g-3">
                                            <div class="col-md-2">
                                                <label class="form-label">Model</label>
                                                <select name="details[model]" id="edit_model" class="form-select"></select>
                                            </div>
                                            <div class="col-md-2">
                                                <label class="form-label">Width</label>
                                                <input type="number" name="measurement[curtain][width]" class="form-control">
                                            </div>

                                            <div class="col-md-2">
                                                <label class="form-label">Height</label>
                                                <input type="number" name="measurement[curtain][height]" class="form-control">
                                            </div>

                                            <div class="col-md-2">
                                                <label class="form-label">Unit</label>
                                                <select name="measurement[curtain][[unit]" class="form-select">
                                                    <option value="cm">CM</option>
                                                    <option value="inch">Inch</option>
                                                </select>
                                            </div>

                                            <div class="col-md-2">
                                                <label class="form-label">Motorized</label>
                                                <select name="details[motorized]" class="form-select">
                                                    <option value="0">No</option>
                                                    <option value="1">Yes</option>
                                                </select>
                                            </div>



                                            <div class="col-md-2">
                                                <label class="form-label" Motor Control></label>
                                                <select name="details[motor_control]" class="form-select">
                                                    <option value="Right">Right</option>
                                                    <option value="Left">Left</option>
                                                </select>
                                            </div>



                                        </div>
                                    </div>
                                    <!-- ================= WALLPAPER ================= -->
                                    <div id="wallpaper_section" class="category_section d-none mb-3">
                                        <h6 class="mb-3 text-muted">Wallpaper Details</h6>

                                        <div class="row g-3">

                                            <div class="col-md-2">
                                                <label class="form-label">Wall Width</label>
                                                <input type="number" name="measurement[wallpaper][width]" class="form-control">
                                                <input type="hidden" name="measurement[wallpaper][unit]" value="m">
                                            </div>

                                            <div class="col-md-2">
                                                <label class="form-label">Wall Height</label>
                                                <input type="number" name="measurement[wallpaper][height]" class="form-control">
                                            </div>

                                            <div class="col-md-2">
                                                <label class="form-label">Roll Qty</label>
                                                <input type="number" name="details[roll_quantity]" class="form-control">
                                            </div>

                                            <div class="col-md-3">
                                                <label class="form-label">Catalogue</label>
                                                <input type="text" name="details[catalogue]" class="form-control">
                                            </div>

                                            <div class="col-md-3">
                                                <label class="form-label">Serial</label>
                                                <input type="text" name="details[serial_no]" class="form-control">
                                            </div>

                                        </div>
                                    </div>

                                    <!-- ================= MATTRESS ================= -->
                                    <div id="mattress_section" class="category_section d-none mb-3">
                                        <h6 class="mb-3 text-muted">Mattress Details</h6>

                                        <div class="row g-3">

                                            <div class="col-md-3">
                                                <label class="form-label">Type</label>
                                                <select name="details[type]" id="mattress_type" class="form-select"></select>
                                            </div>

                                            <div class="col-md-3">
                                                <label class="form-label">Thickness</label>
                                                <select name="details[thickness]" id="mattress_thickness" class="form-select"></select>
                                            </div>
                                            <div class="col-md-3">
                                                <label class="form-label">Unit</label>
                                                <select name="details[unit]" class="form-select">
                                                    <option value="inch">Inch</option>
                                                    <option value="ft">Ft</option>
                                                    <option value="cm">CM</option>
                                                </select>
                                            </div>

                                            <div class="col-md-3">
                                                <label class="form-label">Size</label>
                                                <select name="details[size]" id="mattress_size" class="form-select"></select>
                                            </div>



                                        </div>
                                    </div>


                                    <!-- COMMON -->


                                    <div class="row g-3">
                                        <div class="col-md-2">
                                            <label class="form-label">Quantity</label>
                                            <input type="textr" name="quantity" class="form-control">
                                        </div>

                                        <div class="col-md-10">
                                            <label class="form-label">Note</label>
                                            <input type="text" name="note" class="form-control">
                                        </div>
                                    </div>

                                </div>

                                <!-- FOOTER -->
                                <div class="modal-footer border-top">
                                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancel</button>
                                    <button type="submit" class="btn btn-primary px-4">Save Item</button>
                                </div>

                            </form>

                        </div>
                    </div>
                </div>


            </div>

        </div>
    </div>
<!-- // add room -->

<div class="modal fade" id="addRoomModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="addRoomForm">
                <div class="modal-header">
                    <h5 class="modal-title">Add Room</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">

                    <input type="hidden" name="quotation_id" value="{{ $quotation->id }}">

                    <!-- Room Dropdown -->
                    <div class="mb-3">
                        <label class="form-label">Select Room</label>
                        <select class="form-select" id="room_select" name="room_select">
                            <option value="">Select Room</option>
                            @foreach(App\Models\Room::get() as $room)
                                <option value="{{ $room->id }}">
                                    {{ $room->name }}
                                </option>
                            @endforeach
                            <option value="custom">Custom</option>
                        </select>
                    </div>

                    <!-- Custom Room -->
                    <div class="mb-3 d-none" id="custom_room_div">
                        <label class="form-label">Custom Room Name</label>
                        <input type="text" class="form-control" name="custom_room_name" placeholder="Enter room name">
                    </div>

                </div>

                <div class="modal-footer">
                    <button type="submit" class="btn btn-success">Add Room</button>
                </div>
            </form>
        </div>
    </div>
</div>
<!-- end add room -->
</div>

<script>
    let isEditMode = false;
    // $('#categorySelect').change(function() {

    //     let category = $(this).val();

    //     if (!category) return;

    //     $.get('/config/category/' + category, function(res) {

    //         // build product dropdown dynamically

    //         // call /config/subcategory/{id}
    //         // call /config/catalogue-skus/{product_id}

    //     });

    // });

    $(document).on('click', '.deleteItemBtn', function() {

        let itemId = $(this).data('id');
        let button = $(this);

        Swal.fire({
            title: "Are you sure?",
            text: "This item will be deleted!",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#d33",
            confirmButtonText: "Yes, delete it!"
        }).then((result) => {

            if (result.isConfirmed) {

                $.ajax({
                    url: "{{ url('quotations/items') }}/" + itemId,
                    type: "DELETE",
                    data: {
                        _token: $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(response) {

                        if (response.success) {

                            Swal.fire("Deleted!", response.message, "success");

                            // Remove row from table
                            button.closest('tr').remove();

                        } else {
                            Swal.fire("Error!", response.message, "error");
                        }
                    },
                    error: function() {
                        Swal.fire("Error!", "Something went wrong!", "error");
                    }
                });

            }

        });
    });

    $(document).on('change', '#edit_subcategory', function () {

    let subcategoryId = $(this).val();

    if (!subcategoryId) {
        $('#edit_catalogue').html('<option value="">Select</option>');
        $('#edit_model').html('<option value="">Select</option>');
        return;
    }

    $.ajax({
        url: "{{ url('config/subcategory') }}/" + subcategoryId,
        type: "GET",
        success: function (res) {

            if (!res.status) return;

            // =========================
            // Populate MODELS dropdown
            // =========================
            $('#edit_model').html('<option value="">Select</option>');

            if (res.models && res.models.length > 0) {
                res.models.forEach(function (model) {

                    let selected = '';

                    if (isEditMode && editItemData && editItemData.details && editItemData.details.model == model) {
                        selected = 'selected';
                    }

                    $('#edit_model').append(
                        `<option value="${model}" ${selected}>${model}</option>`
                    );
                });
            }

            // =========================
            // Populate CATALOGUES dropdown
            // =========================
            $('#edit_catalogue').html('<option value="">Select</option>');

            if (res.catalogues && res.catalogues.length > 0) {
                res.catalogues.forEach(function (cat) {

                    let selected = '';

                    if (isEditMode && editItemData && editItemData.product_id == cat.product_id) {
                        selected = 'selected';
                    }

                    $('#edit_catalogue').append(`
                        <option value="${cat.product_id}" ${selected}>
                            ${cat.catalogue} - ${cat.product_name}
                        </option>
                    `);
                });
            }

            // If edit mode → trigger catalogue change to load SKU
            if (isEditMode && editItemData) {
                $('#edit_catalogue').trigger('change');
            }

        },
        error: function (err) {
            console.log(err);
        }
    });

});

    $(document).on('click', '#updateQuotationBtn', function() {

        let quotationId = $('#project_quotation_id').val();
        let formData = new FormData($('#quotationUpdateForm')[0]);

        Swal.fire({
            title: 'Are you sure?',
            text: "Do you want to update this quotation?",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, update it!'
        }).then((result) => {

            if (result.isConfirmed) {

                $.ajax({
                    url: "{{ url('quotations/update') }}",
                    type: "POST", // must be POST
                    data: formData,
                    processData: false,
                    contentType: false,
                    success: function(response) {

                        Swal.fire(
                            'Updated!',
                            'Quotation has been updated successfully.',
                            'success'
                        ).then(() => {
                            //  window.location.href = "{{ url('quotations') }}/" + quotationId;
                        });

                    },
                    error: function(xhr) {

                        let errors = xhr.responseJSON.errors;
                        let errorMessage = '';

                        if (errors) {
                            $.each(errors, function(key, value) {
                                errorMessage += value[0] + "<br>";
                            });
                        } else {
                            errorMessage = 'Something went wrong!';
                        }

                        Swal.fire({
                            icon: 'error',
                            title: 'Validation Error',
                            html: errorMessage
                        });
                    }
                });

            }
        });

    });

    $(document).on('change', '#edit_category', function() {

        let categoryId = $(this).val();
        let categoryName = $('#edit_category option:selected').data('value');

        if (!categoryName) return;

        // Hide all sections
        $('.category_section').addClass('d-none');

        // Show selected section
        $('#' + categoryName + '_section').removeClass('d-none');

        let url = "{{ url('config/category') }}/" + categoryId;

        // Disable while loading
        $('#edit_subcategory, #edit_catalogue, #edit_sku')
            .prop('disabled', true);

        $.ajax({
            url: url,
            type: 'GET',
            success: function(res) {

                if (res.status) {

                    if (!isEditMode) {
                        // Reset dropdowns with default option
                        $('#edit_subcategory')
                            .html('<option value="">Select</option>');

                        $('#edit_catalogue')
                            .html('<option value="">Select</option>');

                        $('#edit_model')
                            .html('<option value="">Select</option>');

                        $('#edit_sku')
                            .html('<option value="">Select</option>');
                    }
                    // MODELS
                    if (res.models && res.models.length > 0) {
                        res.models.forEach(function(model) {
                            $('#edit_model').append(
                                `<option value="${model}">${model}</option>`
                            );
                        });
                    }

                    // SUBCATEGORIES
                    if (res.subcategories && res.subcategories.length > 0) {
                        res.subcategories.forEach(function(sub) {
                            $('#edit_subcategory').append(
                                `<option value="${sub.id}">${sub.name}</option>`
                            );
                        });
                    }

                    // CATALOGUES
                    if (res.catalogues && res.catalogues.length > 0) {
                        res.catalogues.forEach(function(cat) {
                            $('#edit_catalogue').append(`
                            <option value="${cat.product_id}">
                                ${cat.catalogue} (${cat.product_name})
                            </option>
                        `);
                        });
                    }
                }
            },
            complete: function() {
                $('#edit_subcategory, #edit_catalogue, #edit_sku')
                    .prop('disabled', false);
            },
            error: function() {
                console.log('Category load failed');
            }
        });

    });

    let mattressConfig = null; // global variable

    $('#edit_catalogue').on('change', function() {

        let product_id = $(this).val();
        let url = "{{ url('config/catalogue-skus') }}/" + product_id;

        $.get(url, function(res) {

            if (res.status) {

                // SKU dropdown
                if (!isEditMode) {
                    $('#edit_sku').html('<option value="">Select</option>');
                }
                res.skus.forEach(function(sku) {
                    $('#edit_sku').append(`
                    <option value="${sku.variant_id}">
                        ${sku.sku} | ₹${sku.offer_price}
                    </option>
                `);
                });

                // Mattress config
                // if (res.mattress_config) {

                //     mattressConfig = res.mattress_config;

                //     // Type
                //     if (!isEditMode) {
                //         $('#mattress_type').html('<option value="">Select</option>');
                //     } else {

                //     }
                //     mattressConfig.categories.forEach(function(c) {
                //         $('#mattress_type').append(
                //             `<option value="${c}">${c}</option>`
                //         );
                //     });

                //     // Thickness
                //     if (!isEditMode) {
                //         $('#mattress_thickness').html('<option value="">Select</option>');
                //     }
                //     mattressConfig.thickness.forEach(function(t) {
                //         $('#mattress_thickness').append(
                //             `<option value="${t}">${t}</option>`
                //         );
                //     });

                //     // Unit
                //     let unitSelect = $('select[name="details[unit]"]');
                //     if (!isEditMode) {
                //         unitSelect.html('<option value="">Select</option>');
                //     }
                //     mattressConfig.units.forEach(function(u) {
                //         unitSelect.append(
                //             `<option value="${u}">${u.toUpperCase()}</option>`
                //         );
                //     });

                //     // Clear size
                //     if (!isEditMode) {
                //         $('#mattress_size').html('<option value="">Select</option>');
                //     }
                // }

                // Mattress config population
       if (res.mattress_config) {
            mattressConfig = res.mattress_config;

            // Type
            $('#mattress_type').html('<option value="">Select</option>');
            mattressConfig.categories.forEach(c => {
                let selected = '';
                if (isEditMode && editItemData && editItemData.details && editItemData.details.type == c) selected = 'selected';
                $('#mattress_type').append(`<option value="${c}" ${selected}>${c}</option>`);
            });

            // Thickness
            $('#mattress_thickness').html('<option value="">Select</option>');
            mattressConfig.thickness.forEach(t => {
                let selected = '';
                if (isEditMode && editItemData && editItemData.details && editItemData.details.thickness == t) selected = 'selected';
                $('#mattress_thickness').append(`<option value="${t}" ${selected}>${t}</option>`);
            });

            // Unit
            let unitSelect = $('select[name="details[unit]"]');
            unitSelect.html('<option value="">Select</option>');
            mattressConfig.units.forEach(u => {
                let selected = '';
                if (isEditMode && editItemData && editItemData.details && editItemData.details.unit == u) selected = 'selected';
                unitSelect.append(`<option value="${u}" ${selected}>${u.toUpperCase()}</option>`);
            });

            // Size (populate if edit)
            $('#mattress_size').html('<option value="">Select</option>');
            if (isEditMode && editItemData && editItemData.details && editItemData.details.size) {
                let selectedSize = editItemData.details.size;
                let type = editItemData.details.type || $('#mattress_type').val();
                if (type && mattressConfig.sizes[type]) {
                    mattressConfig.sizes[type].forEach(sizeObj => {
                        let displayValue = sizeObj[editItemData.details.unit] || sizeObj['inch'];
                        let selected = (displayValue == selectedSize) ? 'selected' : '';
                        $('#mattress_size').append(`<option value="${displayValue}" ${selected} data-inch="${sizeObj.inch}" data-ft="${sizeObj.ft}" data-cm="${sizeObj.cm}">${displayValue}</option>`);
                    });
                }
            }
        }
            }
        });
    });

    // $('#mattress_type').on('change', function() {

    //     let selectedType = $(this).val();
    //     let selectedUnit = $('select[name="details[unit]"]').val() || 'inch';

    //     if (!mattressConfig || !selectedType) return;

    //     let sizes = mattressConfig.sizes[selectedType];

    //     $('#mattress_size').html('<option value="">Select</option>');

    //     if (sizes) {
    //         sizes.forEach(function(size) {

    //             let displayValue = size[selectedUnit] || size['inch'];

    //             $('#mattress_size').append(`
    //             <option value="${displayValue}"
    //                     data-inch="${size.inch}"
    //                     data-ft="${size.ft}"
    //                     data-cm="${size.cm}">
    //                 ${displayValue}
    //             </option>
    //         `);
    //         });
    //     }
    // });
$('#mattress_type').on('change', function() {
    let selectedType = $(this).val();
    let selectedUnit = $('select[name="details[unit]"]').val() || 'inch';

    if (!mattressConfig || !selectedType) return;

    let sizes = mattressConfig.sizes[selectedType];

    $('#mattress_size').html('<option value="">Select</option>');

    if (sizes) {
        sizes.forEach(function(size) {
            let displayValue = size[selectedUnit] || size['inch'];
            let selected = '';
            if (isEditMode && item && item.details && item.details.size == displayValue) {
                selected = 'selected';
            }

            $('#mattress_size').append(`
                <option value="${displayValue}" ${selected}
                        data-inch="${size.inch}"
                        data-ft="${size.ft}"
                        data-cm="${size.cm}">
                    ${displayValue}
                </option>
            `);
        });
    }
});
    $(document).on('click', '.addItemBtn', function() {
        $('#itemForm')[0].reset();
        // get area id from button
        isEditMode = false;
        let areaId = $(this).data('area');

        // set to input field
        $('#quotation_area_id').val(areaId);

        $('#quotation_item_id').val('');
        $('#edit_category').prop('disabled', false); // enable category again
        $('#itemModal').modal('show');
    });

    // $(document).on('click', '.editItemBtn', function() {

    //     let itemId = $(this).data('id');

    //     // store item id
    //     $('#quotation_item_id').val(itemId);

    //     // reset form
    //     $('#itemForm')[0].reset();
    //     $('.category_section').addClass('d-none');

    //     $.ajax({
    //         url: "{{ url('quotations/items') }}/" + itemId, // create this route
    //         type: "GET",
    //         success: function(res) {

    //             if (res.success) {

    //                 let item = res.data;

    //                 // Set area
    //                 $('#quotation_area_id').val(item.area_id);

    //                 // Set category
    //                 $('#edit_category').val(item.category_id).trigger('change');

    //                 // Disable category (readonly)
    //                 $('#edit_category').prop('disabled', true);

    //                 // Wait little for dropdowns to load
    //                 setTimeout(function() {

    //                     $('#edit_subcategory').val(item.subcategory_id);
    //                     $('#edit_catalogue').val(item.product_id).trigger('change');

    //                     setTimeout(function() {
    //                         $('#edit_sku').val(item.variant_id);
    //                     }, 500);

    //                 }, 500);

    //                 // Quantity & note
    //                 $('input[name="quantity"]').val(item.quantity);
    //                 $('input[name="note"]').val(item.note);

    //                 // Measurement
    //                 if (item.measurement) {
    //                     $('input[name="measurement[width]"]').val(item.measurement.width);
    //                     $('input[name="measurement[height]"]').val(item.measurement.height);
    //                     $('select[name="measurement[unit]"]').val(item.measurement.unit);
    //                 }

    //                 // Details
    //                 if (item.details) {

    //                     // Curtain
    //                     $('#edit_model').val(item.details.model);
    //                     $('select[name="details[motorized]"]').val(item.details.motorized);
    //                     $('select[name="details[motor_control]"]').val(item.details.motor_control);

    //                     // Mattress
    //                     $('#mattress_type').val(item.details.type);
    //                     $('#mattress_thickness').val(item.details.thickness);
    //                     $('select[name="details[unit]"]').val(item.details.unit);

    //                     // Wallpaper
    //                     $('input[name="details[roll_quantity]"]').val(item.details.roll_quantity);
    //                     $('input[name="details[catalogue]"]').val(item.details.catalogue);
    //                     $('input[name="details[serial_no]"]').val(item.details.serial_no);
    //                 }


    //             }
    //         }
    //     });
    //  $('#itemModal').modal('show');
    // });

    $(document).on('click', '.editItemBtn', function() {
        $('#itemForm')[0].reset();
        isEditMode = true;

        let itemId = $(this).data('id');

        // store item id
        $('#quotation_item_id').val(itemId);

        // reset form
        // $('#itemForm')[0].reset();
        $('.category_section').addClass('d-none');

        $.ajax({
            url: "{{ url('quotations/edit/items') }}/" + itemId, // create this route
            type: "GET",
            success: function(res) {

                if (res.success) {

                    editItemData = res.data; // <-- store globally
            let item = res.data; // for local use
            isEditMode = true;
                    // Set area
                    $('#quotation_area_id').val(item.area_id);

                    // Set category
                    $('#edit_category').val(item.category_id).trigger('change');

                    // Disable category (readonly)
                    $('#edit_category').prop('disabled', true);

                    // Wait little for dropdowns to load
                    setTimeout(function() {

                        $('#edit_subcategory').val(item.subcategory_id);
                        $('#edit_catalogue').val(item.product_id).trigger('change');

                        setTimeout(function() {
                            $('#edit_sku').val(item.variant_id);
                        }, 500);

                    }, 500);

                    // Quantity & note
                    $('input[name="quantity"]').val(item.quantity);
                    $('input[name="note"]').val(item.note);

                    // Measurement
                    if (item.measurement) {
                        $('input[name="measurement[width]"]').val(item.measurement.width);
                        $('input[name="measurement[height]"]').val(item.measurement.height);
                        $('select[name="measurement[unit]"]').val(item.measurement.unit);
                    }

                    // Details
                    if (item.details) {

                        // Curtain
                        $('#edit_model').val(item.details.model);
                        $('select[name="details[motorized]"]').val(item.details.motorized);
                        $('select[name="details[motor_control]"]').val(item.details.motor_control);

                        // Mattress

                        $('#mattress_type').val(item.details.type);
                        $('#mattress_size').val(item.details.size);
                        $('#mattress_thickness').val(item.details.thickness);
                        $('select[name="details[unit]"]').val(item.details.unit);

                        // Wallpaper
                        $('input[name="details[roll_quantity]"]').val(item.details.roll_quantity);
                        $('input[name="details[catalogue]"]').val(item.details.catalogue);
                        $('input[name="details[serial_no]"]').val(item.details.serial_no);
                    }


                }
            }
        });
        $('#itemModal').modal('show');
    });

    $('select[name="details[unit]"]').on('change', function() {

        let selectedUnit = $(this).val();

        $('#mattress_size option').each(function() {

            if ($(this).val() === "") return;

            let newValue = $(this).data(selectedUnit);

            if (newValue) {
                $(this).text(newValue);
            }
        });

    });
    $(document).on('submit', '#itemForm', function(e) {
        e.preventDefault();

        let form = $(this);
        let formData = new FormData(this);
        let submitBtn = form.find('button[type="submit"]');

        let itemId = $('#quotation_item_id').val();
        let areaId = $('#quotation_area_id').val();

        if (!itemId && !areaId) {
            Swal.fire({
                icon: 'error',
                title: 'Area not selected',
                text: 'Room/Area ID missing'
            });
            return;
        }

        let url;

        if (itemId) {
            url = "{{ route('quotations.items.update', ':id') }}";
            url = url.replace(':id', itemId);
        } else {
            url = "{{ route('quotations.items.store', ':room') }}";
            url = url.replace(':room', areaId);
        }

        // Clear old errors
        $('.is-invalid').removeClass('is-invalid');
        $('.invalid-feedback').remove();

        submitBtn.prop('disabled', true).text('Saving...');

        $.ajax({
            url: url,
            type: "POST",
            data: formData,
            processData: false,
            contentType: false,

            success: function(response) {

                submitBtn.prop('disabled', false).text('Save Item');

                if (response.success) {

                    Swal.fire({
                        icon: 'success',
                        title: 'Success',
                        text: response.message,
                        timer: 1500,
                        showConfirmButton: false
                    });

                    // Close modal
                    $('#itemModal').modal('hide');

                    // Optional: reload only items section
                     location.reload();
                }
            },

            error: function(xhr) {

                submitBtn.prop('disabled', false).text('Save Item');

                if (xhr.status === 422) {

                    let errors = xhr.responseJSON.errors;

                    $.each(errors, function(key, value) {

                        let field = $('[name="' + key + '"]');

                        field.addClass('is-invalid');

                        field.after(
                            '<div class="invalid-feedback">' + value[0] + '</div>'
                        );
                    });

                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'Something went wrong'
                    });
                }
            }
        });
    });

    $(document).on('click', '.editRoomBtn', function () {

    let roomId = $(this).data('id');
    let currentName = $(this).data('name');

    // Build dropdown options from blade
    let roomOptions = `<option value="">Select Room</option>`;

    @foreach(App\Models\Room::get() as $room)
        roomOptions += `<option value="{{ $room->name }}">{{ $room->name }}</option>`;
    @endforeach

    roomOptions += `<option value="custom">Custom</option>`;

    Swal.fire({
        title: 'Edit Room',
        html: `
            <select id="swal_room_select" class="swal2-select">
                ${roomOptions}
            </select>
            <input type="text" id="swal_custom_room" class="swal2-input"
                placeholder="Enter custom room name"
                style="display:none;">
        `,
        showCancelButton: true,
        confirmButtonText: 'Update',
        didOpen: () => {

            // Preselect if exists
            let exists = false;
            $('#swal_room_select option').each(function () {
                if ($(this).val() === currentName) {
                    $(this).prop('selected', true);
                    exists = true;
                }
            });

            if (!exists) {
                $('#swal_room_select').val('custom');
                $('#swal_custom_room').val(currentName).show();
            }

            // On change
            $('#swal_room_select').on('change', function () {
                if ($(this).val() === 'custom') {
                    $('#swal_custom_room').show();
                } else {
                    $('#swal_custom_room').hide();
                }
            });
        },
        preConfirm: () => {

            let selected = $('#swal_room_select').val();
            let customName = $('#swal_custom_room').val();

            let finalName = selected === 'custom' ? customName : selected;

            if (!finalName) {
                Swal.showValidationMessage('Room name is required');
                return false;
            }

            return finalName;
        }

    }).then((result) => {

        if (result.isConfirmed) {

            $.ajax({
                url: "{{ url('quotations/rooms') }}/" + roomId,
                type: "PUT",
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: {
                    area_name: result.value
                },
                success: function (res) {

                    if (res.success) {
                        Swal.fire('Updated!', res.message, 'success')
                            .then(() => location.reload());
                    } else {
                        Swal.fire('Error!', res.message, 'error');
                    }
                }
            });

        }
    });

});

$(document).on('click', '.deleteRoomBtn', function () {

    let roomId = $(this).data('id');

    Swal.fire({
        title: 'Are you sure?',
        text: "All items inside this room will be deleted!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        confirmButtonText: 'Yes, delete it!'
    }).then((result) => {

        if (result.isConfirmed) {

            $.ajax({
                url: "{{ url('quotations/rooms') }}/" + roomId,
                type: "DELETE",
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function (res) {

                    if (res.success) {
                        Swal.fire('Deleted!', res.message, 'success')
                            .then(() => location.reload());
                    } else {
                        Swal.fire('Error!', res.message, 'error');
                    }
                }
            });

        }
    });
});

$(document).on('change', '#room_select', function () {

    if ($(this).val() === 'custom') {
        $('#custom_room_div').removeClass('d-none');
    } else {
        $('#custom_room_div').addClass('d-none');
    }

});

$(document).on('submit', '#addRoomForm', function (e) {
    e.preventDefault();

    let quotationId = $('input[name="quotation_id"]').val();

    $.ajax({
        url: "{{ url('quotations') }}/" + quotationId + "/rooms",
        type: "POST",
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        data: $(this).serialize(),
        success: function (res) {

            if (res.success) {

                $('#addRoomModal').modal('hide');

                Swal.fire({
                    icon: 'success',
                    title: 'Success',
                    text: res.message
                }).then(() => location.reload());

            } else {
                Swal.fire('Error', res.message, 'error');
            }
        }
    });
});
</script>
@endsection